!define DEFAULT_DIR "C:\Garmin\Maps\walleycz"
!define INSTALLER_DESCRIPTION "walleycz"
!define INSTALLER_NAME "walleycz"
!define MAPNAME "42029999"
!define PRODUCT_ID "152"
!define REG_KEY "walleycz"
!define INDEX
!define TYPNAME "42020100.TYP"

SetCompressor /SOLID lzma

; Includes
!include "MUI2.nsh"

; Installer pages
!define MUI_CUSTOMFUNCTION_GUIINIT myGuiInit
!insertmacro MUI_PAGE_WELCOME
!insertmacro MUI_PAGE_LICENSE "${MAPNAME}_license.txt"
!insertmacro MUI_PAGE_DIRECTORY
!insertmacro MUI_PAGE_INSTFILES
!insertmacro MUI_PAGE_FINISH

; Uninstaller pages
!define MUI_UNPAGE_INSTFILES

; Language files
!define MUI_LANGDLL_ALLLANGUAGES
!insertmacro MUI_LANGUAGE "English"
!insertmacro MUI_LANGUAGE "French"
!insertmacro MUI_LANGUAGE "Spanish"
!insertmacro MUI_LANGUAGE "German"
!insertmacro MUI_LANGUAGE "Dutch"


LangString AlreadyInstalled ${LANG_ENGLISH} "${INSTALLER_NAME} is already installed. $\n$\nClick `OK` to remove the previous version and continue installation or `Cancel` to cancel this upgrade."
LangString AlreadyInstalled ${LANG_FRENCH} "${INSTALLER_NAME} est d�j� install�. $\n$\nAppuyez sur `OK` pour retirer la version pr�c�dente et continuer avec l'installation ou sur `Annuler` pour annuler cette mise � jour."
LangString AlreadyInstalled ${LANG_SPANISH} "${INSTALLER_NAME} ya est� instalado. $\n$\nPulse `Aceptar` para eliminar la versi�n anterior y continuar la instalaci�n o `Cancelar` para cancelar esta actualizaci�n."
LangString AlreadyInstalled ${LANG_GERMAN} "${INSTALLER_NAME} ist bereits installiert. $\n$\nKlick `OK` um die alte Version zu deinstallieren oder `Abbrechen` um die Installation abzubrechen."
LangString AlreadyInstalled ${LANG_DUTCH} "${INSTALLER_NAME} is reeds geinstalleerd. $\n$\nKlik op `OK` om de oude versie te verwijderen of `Annuleren` om deze update te onderbreken."

; Reservefiles
!insertmacro MUI_RESERVEFILE_LANGDLL ;Language selection dialog


Name "${INSTALLER_DESCRIPTION}"
OutFile "${INSTALLER_NAME}.exe"
InstallDir "${DEFAULT_DIR}"

Function .onInit
  !insertmacro MUI_LANGDLL_DISPLAY
FunctionEnd

Function myGUIInit
  ;Read $INSTDIR from the registry
  ClearErrors
  ReadRegStr $INSTDIR HKLM "SOFTWARE\Garmin\MapSource\Families\${REG_KEY}\${PRODUCT_ID}" "LOC"
  IfErrors +2
  StrCmp $INSTDIR "" 0 +2
  StrCpy $INSTDIR "${DEFAULT_DIR}"
  
  ; Uninstall before installing (code from http://nsis.sourceforge.net/Auto-uninstall_old_before_installing_new )
  ReadRegStr $R0 HKLM \
  "Software\Microsoft\Windows\CurrentVersion\Uninstall\${REG_KEY}" "UninstallString"
  StrCmp $R0 "" done
 
  IfSilent silent
  MessageBox MB_OKCANCEL|MB_ICONEXCLAMATION "$(AlreadyInstalled)" IDOK uninst
  Abort

  ;Run the uninstaller
  uninst:
  ClearErrors
  ExecWait '"$R0" /S ' ;Do not copy the uninstaller to a temp file
 
  IfErrors no_remove_uninstaller done
    ;You can either use Delete /REBOOTOK in the uninstaller or add some code
    ;here to remove the uninstaller. Use a registry key to check
    ;whether the user has chosen to uninstall. If you are using an uninstaller
    ;components page, make sure all sections are uninstalled.
  no_remove_uninstaller:
  
  Goto done
 
  silent:
  ExecWait '"$R0" /S ' ;Do not copy the uninstaller to a temp file
 
  done:
 
FunctionEnd

Function un.onInit
!insertmacro MUI_UNGETLANGUAGE
FunctionEnd

Section "MainSection" SectionMain
; Files to be installed
  SetOutPath "$INSTDIR"
  File "${MAPNAME}.img"
  File "${MAPNAME}_mdr.img"
  File "${MAPNAME}.mdx"
  File "42020100.TYP"
  File "${MAPNAME}.tdb"
  File "42001200.img"
  File "42001201.img"
  File "42001202.img"
  File "42001203.img"
  File "42001204.img"
  File "42001205.img"
  File "42001206.img"
  File "42020000.img"
  File "42020001.img"
  File "42020002.img"
  File "42020003.img"
  File "42020004.img"
  File "42020005.img"
  File "42020006.img"
  File "42020007.img"
  File "42020008.img"
  File "42020009.img"
  File "42020010.img"
  File "42020011.img"
  File "42020012.img"
  File "42020013.img"
  File "42020014.img"
  File "42020015.img"
  File "42020016.img"
  File "42020017.img"
  File "42020018.img"
  File "42020019.img"
  File "42020020.img"
  File "42020021.img"
  File "42020022.img"
  File "42020023.img"
  File "42020024.img"
  File "42020025.img"
  File "42020026.img"
  File "42020027.img"
  File "42020028.img"
  File "42020029.img"
  File "42020030.img"
  File "42020031.img"
  File "42020032.img"
  File "42020033.img"
  File "42020034.img"
  File "42020035.img"
  File "42020036.img"
  File "42020037.img"
  File "42020038.img"
  File "42020039.img"
  File "42020040.img"
  File "42020041.img"
  File "42020042.img"
  File "42020043.img"
  File "42020044.img"
  File "42020045.img"
  File "42020046.img"
  File "42020047.img"
  File "42020048.img"
  File "42020049.img"
  File "42020050.img"
  File "42020051.img"
  File "42020052.img"
  File "42020053.img"
  File "42020054.img"
  File "42020055.img"
  File "42020056.img"
  File "42020057.img"
  File "42020058.img"
  File "42020059.img"
  File "42020060.img"
  File "42020061.img"
  File "42020062.img"
  File "42020063.img"
  File "42020064.img"
  File "42020065.img"
  File "42020066.img"
  File "42020067.img"
  File "42020068.img"
  File "42020069.img"
  File "42020070.img"
  File "42020071.img"
  File "42020072.img"
  File "42020073.img"
  File "42020074.img"
  File "42020075.img"
  File "42020076.img"
  File "42020077.img"
  File "42020078.img"
  File "42020079.img"
  File "42020080.img"
  File "42020081.img"
  File "42020082.img"
  File "42020083.img"
  File "42020084.img"
  File "42020085.img"
  File "42020086.img"
  File "42020087.img"
  File "42020088.img"
  File "42020089.img"
  File "42020090.img"

; Create MapSource registry keys
  WriteRegBin HKLM "SOFTWARE\Garmin\MapSource\Families\${REG_KEY}" "ID" 9600
!ifdef INDEX  
  WriteRegStr HKLM "SOFTWARE\Garmin\MapSource\Families\${REG_KEY}" "IDX" "$INSTDIR\${MAPNAME}.mdx"
  WriteRegStr HKLM "SOFTWARE\Garmin\MapSource\Families\${REG_KEY}" "MDR" "$INSTDIR\${MAPNAME}_mdr.img"
!endif
!ifdef TYPNAME  
  WriteRegStr HKLM "SOFTWARE\Garmin\MapSource\Families\${REG_KEY}" "TYP" "$INSTDIR\${TYPNAME}"
!endif
  WriteRegStr HKLM "SOFTWARE\Garmin\MapSource\Families\${REG_KEY}\${PRODUCT_ID}" "BMAP" "$INSTDIR\${MAPNAME}.img"
  WriteRegStr HKLM "SOFTWARE\Garmin\MapSource\Families\${REG_KEY}\${PRODUCT_ID}" "LOC" "$INSTDIR"
  WriteRegStr HKLM "SOFTWARE\Garmin\MapSource\Families\${REG_KEY}\${PRODUCT_ID}" "TDB" "$INSTDIR\${MAPNAME}.tdb"
  
; Write uninstaller
  WriteUninstaller "$INSTDIR\Uninstall.exe"

; Create uninstaller registry keys
  WriteRegStr HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\${REG_KEY}" "DisplayName" "$(^Name)"
  WriteRegStr HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\${REG_KEY}" "UninstallString" "$INSTDIR\Uninstall.exe"
  WriteRegDWORD HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\${REG_KEY}" "NoModify" 1
  
SectionEnd

Section "Uninstall"
; Files to be uninstalled
  Delete "$INSTDIR\${MAPNAME}.img"
  Delete "$INSTDIR\${MAPNAME}_mdr.img"
  Delete "$INSTDIR\${MAPNAME}.mdx"
  Delete "$INSTDIR\42020100.TYP"
  Delete "$INSTDIR\${MAPNAME}.tdb"
  Delete "$INSTDIR\42001200.img"
  Delete "$INSTDIR\42001201.img"
  Delete "$INSTDIR\42001202.img"
  Delete "$INSTDIR\42001203.img"
  Delete "$INSTDIR\42001204.img"
  Delete "$INSTDIR\42001205.img"
  Delete "$INSTDIR\42001206.img"
  Delete "$INSTDIR\42020000.img"
  Delete "$INSTDIR\42020001.img"
  Delete "$INSTDIR\42020002.img"
  Delete "$INSTDIR\42020003.img"
  Delete "$INSTDIR\42020004.img"
  Delete "$INSTDIR\42020005.img"
  Delete "$INSTDIR\42020006.img"
  Delete "$INSTDIR\42020007.img"
  Delete "$INSTDIR\42020008.img"
  Delete "$INSTDIR\42020009.img"
  Delete "$INSTDIR\42020010.img"
  Delete "$INSTDIR\42020011.img"
  Delete "$INSTDIR\42020012.img"
  Delete "$INSTDIR\42020013.img"
  Delete "$INSTDIR\42020014.img"
  Delete "$INSTDIR\42020015.img"
  Delete "$INSTDIR\42020016.img"
  Delete "$INSTDIR\42020017.img"
  Delete "$INSTDIR\42020018.img"
  Delete "$INSTDIR\42020019.img"
  Delete "$INSTDIR\42020020.img"
  Delete "$INSTDIR\42020021.img"
  Delete "$INSTDIR\42020022.img"
  Delete "$INSTDIR\42020023.img"
  Delete "$INSTDIR\42020024.img"
  Delete "$INSTDIR\42020025.img"
  Delete "$INSTDIR\42020026.img"
  Delete "$INSTDIR\42020027.img"
  Delete "$INSTDIR\42020028.img"
  Delete "$INSTDIR\42020029.img"
  Delete "$INSTDIR\42020030.img"
  Delete "$INSTDIR\42020031.img"
  Delete "$INSTDIR\42020032.img"
  Delete "$INSTDIR\42020033.img"
  Delete "$INSTDIR\42020034.img"
  Delete "$INSTDIR\42020035.img"
  Delete "$INSTDIR\42020036.img"
  Delete "$INSTDIR\42020037.img"
  Delete "$INSTDIR\42020038.img"
  Delete "$INSTDIR\42020039.img"
  Delete "$INSTDIR\42020040.img"
  Delete "$INSTDIR\42020041.img"
  Delete "$INSTDIR\42020042.img"
  Delete "$INSTDIR\42020043.img"
  Delete "$INSTDIR\42020044.img"
  Delete "$INSTDIR\42020045.img"
  Delete "$INSTDIR\42020046.img"
  Delete "$INSTDIR\42020047.img"
  Delete "$INSTDIR\42020048.img"
  Delete "$INSTDIR\42020049.img"
  Delete "$INSTDIR\42020050.img"
  Delete "$INSTDIR\42020051.img"
  Delete "$INSTDIR\42020052.img"
  Delete "$INSTDIR\42020053.img"
  Delete "$INSTDIR\42020054.img"
  Delete "$INSTDIR\42020055.img"
  Delete "$INSTDIR\42020056.img"
  Delete "$INSTDIR\42020057.img"
  Delete "$INSTDIR\42020058.img"
  Delete "$INSTDIR\42020059.img"
  Delete "$INSTDIR\42020060.img"
  Delete "$INSTDIR\42020061.img"
  Delete "$INSTDIR\42020062.img"
  Delete "$INSTDIR\42020063.img"
  Delete "$INSTDIR\42020064.img"
  Delete "$INSTDIR\42020065.img"
  Delete "$INSTDIR\42020066.img"
  Delete "$INSTDIR\42020067.img"
  Delete "$INSTDIR\42020068.img"
  Delete "$INSTDIR\42020069.img"
  Delete "$INSTDIR\42020070.img"
  Delete "$INSTDIR\42020071.img"
  Delete "$INSTDIR\42020072.img"
  Delete "$INSTDIR\42020073.img"
  Delete "$INSTDIR\42020074.img"
  Delete "$INSTDIR\42020075.img"
  Delete "$INSTDIR\42020076.img"
  Delete "$INSTDIR\42020077.img"
  Delete "$INSTDIR\42020078.img"
  Delete "$INSTDIR\42020079.img"
  Delete "$INSTDIR\42020080.img"
  Delete "$INSTDIR\42020081.img"
  Delete "$INSTDIR\42020082.img"
  Delete "$INSTDIR\42020083.img"
  Delete "$INSTDIR\42020084.img"
  Delete "$INSTDIR\42020085.img"
  Delete "$INSTDIR\42020086.img"
  Delete "$INSTDIR\42020087.img"
  Delete "$INSTDIR\42020088.img"
  Delete "$INSTDIR\42020089.img"
  Delete "$INSTDIR\42020090.img"
  Delete "$INSTDIR\Uninstall.exe"

  RmDir "$INSTDIR"

; Registry cleanup
  DeleteRegValue HKLM "SOFTWARE\Garmin\MapSource\Families\${REG_KEY}" "ID"
!ifdef INDEX  
  DeleteRegValue HKLM "SOFTWARE\Garmin\MapSource\Families\${REG_KEY}" "IDX"
  DeleteRegValue HKLM "SOFTWARE\Garmin\MapSource\Families\${REG_KEY}" "MDR"
!endif
!ifdef TYPNAME  
  DeleteRegValue HKLM "SOFTWARE\Garmin\MapSource\Families\${REG_KEY}" "TYP"
!endif
  DeleteRegValue HKLM "SOFTWARE\Garmin\MapSource\Families\${REG_KEY}\${PRODUCT_ID}" "BMAP"
  DeleteRegValue HKLM "SOFTWARE\Garmin\MapSource\Families\${REG_KEY}\${PRODUCT_ID}" "LOC"
  DeleteRegValue HKLM "SOFTWARE\Garmin\MapSource\Families\${REG_KEY}\${PRODUCT_ID}" "TDB"
  DeleteRegKey /IfEmpty HKLM "SOFTWARE\Garmin\MapSource\Families\${REG_KEY}\${PRODUCT_ID}"
  DeleteRegKey /IfEmpty HKLM "SOFTWARE\Garmin\MapSource\Families\${REG_KEY}"
  
  DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${REG_KEY}"

SectionEnd
